/* FrequencyList.java (skeleton)
 * CS 136 Spring 2007
 * Tutorial 10 - List Processing, Generics, and Iteration
 */

/* A frequency list is a list of items along with their frequencies.
 * For this implementation, the generic type parameter T represents the
 * type of item whose frequencies we are counting, and we define the
 * frequency of item T to be the number of times add(T) has been called.
 * (More precisely, the number of times add(T2) has been called with
 * T2.equals(T).)
 * 
 * The underlying data structure for the implementation is a GenList (like
 * a Scheme list) of FrequencyPair<T> objects, each of which stores an item
 * of type T and an integer frequency.
 */
public class FrequencyList<T> {
  /* The list of items and frequencies, stored in any order. */
  private GenList<FrequencyPair<T>> flist;
  
  /* Creates a new frequency list, initially empty. */
  public FrequencyList() {
    //TODO
  }
  
  /* Checks if this frequency list is empty.
   * pre: true
   * post: true
   * return: true iff this frequency list is empty.
   */
  public boolean empty() {
    // TODO
    return false;
  }
  
  /* Gets the length of this frequency list.
   * pre: true
   * post: true
   * return: The number of distinct items that have been
   *         added to this frequency list.
   */
  public int length() {
    //TODO
    return 0;
  }
  
  /* Adds an item to this frequency list.
   * pre: item != null
   * post: If item has not been added before, it is
   *       added to the frequency list with frequency 1.
   *       Otherwise, the frequency of item in the list
   *       is increased by 1.
   */
  public void add (T item) {
    //TODO
  }
  
  /* Gets the most frequent item in the list.
   * pre: !this.empty()
   * post: true
   * return: The most frequently added item.
   *         If there is more than one item with the highest
   *         frequency, any one of them is returned.
   */
  public T mostFrequent() {
    //TODO
    return null;
  }
  
  /* Gets the k most frequently added items, along with their frequencies.
   * pre: !this.empty() && (k > 0)
   * post: true
   * return: A GenList of FrequencyPair<T>s containing the k items with
   *         the highest frequencies, sorted from least to most frequent.
   *         If this.length() < k, then the length of the returned list
   *         is this.length(); otherwise it is k.
   */
  public GenList<FrequencyPair<T>> mostFrequent( int k ) {
    //TODO
    return null;
  }
  
  /* Helper method for mostFrequent(int k) which inserts a given item into
   * the given list so that the result is sorted by increasing frequency.
   * pre: (item != null && lst != null) and item is not in lst.
   * post: true
   * return: A GenList of FrequencyPair<T>s with all the items in lst,
   *         plus item, sorted from least to most frequent.
   */
  private GenList<FrequencyPair<T>> insert( FrequencyPair<T> item, GenList<FrequencyPair<T>> lst ) {
    if( null == lst )
      return new GenList<FrequencyPair<T>>(item,null);
    else if( item.lessFrequentThan(lst.first) )
      return new GenList<FrequencyPair<T>>(item,lst);
    else
      return new GenList<FrequencyPair<T>>(lst.first,insert(item,lst.rest));
  }

}