/* FrequencyPair.java
 * CS 136 Spring 2007
 * Tutorial 10 - List Processing, Generics, and Iteration
 */

/* A FrequencyPair represents some item of type T
 * and an associated integer frequency.
 * Usually, the first constructor should be used for
 * an initial frequency of 1, and then the incrFreq()
 * method should be called to increment the frequency.
 */
public class FrequencyPair<T> {
  /* The item whose frequency we are counting. */
  private T item;
  
  /* The frequency of the item. */
  private int freq;
  
  /* Constructs a new FrequencyPair storing the
   * given item and with initial frequency 1.
   */
  public FrequencyPair (T itm) {
    item = itm;
    freq = 1;
  }
  
  /* Constructs a new FrequencyPair storing the
   * given item and with the initial frequency
   * set to f.
   */
  public FrequencyPair( T itm, int f ) {
    item = itm;
    freq = f;
  }
  
  /* Gets the item this FrequencyPair refers to.
   * pre: true
   * post: true
   * return: The item associated with this FrequencyPair.
   */
  public T getItem() { return item; }
  
  /* Gets the frequency of this item.
   * pre: true
   * post: true
   * return: The frequency associated with this FrequencyPair.
   */
  public int getFrequency() { return freq; }
  
  /* Increments the frequency of this item.
   * pre: true
   * post: The associated frequency is increased by 1.
   */
  public void incrFreq() { ++freq; }
  
  /* Tests whether the frequency associated with this pair is
   * less than the frequency associated with the given pair.
   * pre: other != null
   * post: true
   * return: true iff this has a lower frequency than other.
   */
  public boolean lessFrequentThan( FrequencyPair<T> other ) {
    return freq < other.freq;
  }
  
  /* Tests whether this pair is the same as the given one.
   * pre: other != null
   * post: true
   * return: true iff the associated items are .equal to
   *         each other and the frequencies are the same.
   */
  public boolean equals( FrequencyPair<T> other ) {
    return item.equals(other.item) && (freq == other.freq);
  }
}