/* FrequencyListRecursive.java (recursive version)
 * CS 136 Spring 2007
 * Tutorial 10 - List Processing, Generics, and Iteration
 */

/* A frequency list is a list of items along with their frequencies.
 * For this implementation, the generic type parameter T represents the
 * type of item whose frequencies we are counting, and we define the
 * frequency of item T to be the number of times add(T) has been called.
 * (More precisely, the number of times add(T2) has been called with
 * T2.equals(T).)
 * 
 * The underlying data structure for the implementation is a GenList (like
 * a Scheme list) of FrequencyPair<T> objects, each of which stores an item
 * of type T and an integer frequency.
 */
public class FrequencyListRecursive<T> {
  /* The list of items and frequencies, stored in any order. */
  private GenList<FrequencyPair<T>> flist;
  
  /* Creates a new frequency list, initially empty. */
  public FrequencyListRecursive() {
    flist = null;
  }
  
  /* Checks if this frequency list is empty.
   * pre: true
   * post: true
   * return: true iff this frequency list is empty.
   */
  public boolean empty() {
    return null == flist;
  }
  
  /* Gets the length of this frequency list.
   * pre: true
   * post: true
   * return: The number of distinct items that have been
   *         added to this frequency list.
   */
  public int length() {
    return lengthHelper(flist);
  }
  
  /* Gets the length of this given list.
   * Helper method for length() and mostFrequentHelper(int k).
   * pre: true
   * post: true
   * return: The number of items in the given list
   *         (0 if lst is null).
   */
  private int lengthHelper( GenList<FrequencyPair<T>> lst ) {
    if( null == lst ) return 0;
    else return 1 + lengthHelper(lst.rest);
  }
  
  /* Adds an item to this frequency list.
   * pre: item != null
   * post: If item has not been added before, it is
   *       added to the frequency list with frequency 1.
   *       Otherwise, the frequency of item in the list
   *       is increased by 1.
   */
  public void add (T item) {
    flist = addHelper(item,flist);
  }
  
  /* Helper method for add.
   * pre: item != null
   * post: true
   * return: lst with the frequency of item increased by 1,
   *         or with a new FrequencyPair for item added with
   *         frequency 1.
   */
  private GenList<FrequencyPair<T>> addHelper (T item, GenList<FrequencyPair<T>> lst) {
    if (null == lst)
      return new GenList<FrequencyPair<T>> (new FrequencyPair<T>(item), null);
    else if (lst.first.getItem().equals(item)) {
      lst.first.incrFreq();
      return lst;
    }
    else 
      return new GenList<FrequencyPair<T>>(lst.first, addHelper( item, lst.rest ));
  }
  
  /* Gets the most frequent item in the list.
   * pre: !this.empty()
   * post: true
   * return: The most frequently added item.
   *         If there is more than one item with the highest
   *         frequency, any one of them is returned.
   */
  public T mostFrequent() {
    return mostFrequentHelper (flist.first, flist.rest);
  }
  
  /* Helper method for mostFrequent.
   * pre: soFar != null
   * post: true
   * return: The item in soFar, or an item from lst with
   *         higher frequency than soFar.
   */
  private T mostFrequentHelper (FrequencyPair<T> soFar, GenList<FrequencyPair<T>> lst) {
    if (null == lst)
      return soFar.getItem();
    else if (soFar.lessFrequentThan(lst.first))
      return mostFrequentHelper( lst.first, lst.rest );
    else return mostFrequentHelper( soFar, lst.rest );
  }
  
  /* Gets the k most frequently added items, along with their frequencies.
   * pre: !this.empty() && (k > 0)
   * post: true
   * return: A GenList of FrequencyPair<T>s containing the k items with
   *         the highest frequencies, sorted from least to most frequent.
   *         If this.length() < k, then the length of the returned list
   *         is this.length(); otherwise it is k.
   */
  public GenList<FrequencyPair<T>> mostFrequent( int k ) {
    return mostFrequentHelper( k, new GenList<FrequencyPair<T>>(flist.first,null), flist.rest );
  }
  
  /* Helper method for mostFrequent.
   * pre: (soFar != null) && (k > 0), all items in soFar are non-null
   *      and are sorted from least to most frequent,
   *      all items in soFar are distinct from those in lst.
   * post: true
   * return: A GenList of FrequencyPair<T>s containing the k items in
   *         soFar or in lst with the highest frequencies, sorted from 
   *         least to most frequent.
   *         The length of the returned list is never more than k
   *         and is less than k only when there are fewer than k elements in
   *         soFar and lst.
   */
  private GenList<FrequencyPair<T>> mostFrequentHelper( int k, GenList<FrequencyPair<T>> soFar, GenList<FrequencyPair<T>> lst ) {
    if( null == lst )
      return soFar;
    else if( lengthHelper(soFar) < k )
      return mostFrequentHelper( k, insert(lst.first, soFar), lst.rest );
    else if( soFar.first.lessFrequentThan( lst.first ) )
      return mostFrequentHelper( k, insert(lst.first, soFar.rest), lst.rest );
    else
      return mostFrequentHelper( k, soFar, lst.rest );
  }
  
  /* Helper method for mostFrequentHelper(int k) which inserts a given item into
   * the given list so that the result is sorted by increasing frequency.
   * pre: (item != null && lst != null) and item is not in lst.
   * post: true
   * return: A GenList of FrequencyPair<T>s with all the items in lst,
   *         plus item, sorted from least to most frequent.
   */
  private GenList<FrequencyPair<T>> insert( FrequencyPair<T> item, GenList<FrequencyPair<T>> lst ) {
    if( null == lst )
      return new GenList<FrequencyPair<T>>(item,null);
    else if( item.lessFrequentThan(lst.first) )
      return new GenList<FrequencyPair<T>>(item,lst);
    else
      return new GenList<FrequencyPair<T>>(lst.first,insert(item,lst.rest));
  }

}