/* Tests for the FrequencyList class. */
public class FrequencyListTest {
  
  /* Tests the empty and length methods on an empty freq. list. */
  public static boolean testEmptyLengthNone() {
    FrequencyList<Double> fl = new FrequencyList<Double>();
    return fl.empty();
  }
  
  /* Tests the empty and length methods on a non-empty
   * freq. list. */
  public static boolean testEmptyLengthMany() {
    FrequencyList<Object> fl = new FrequencyList<Object>();
    fl.add( "a string" );
    fl.add( Integer.valueOf(5) );
    fl.add( new FrequencyList<Object>() );
    return
      !fl.empty() &&
      (fl.length() == 3);
  }
  
  /* Adds one item to an empty list, then tests the mostFrequent()
   * method on this list. */
  public static boolean testFreqOne() {
    FrequencyList<Integer> fl = new FrequencyList<Integer>();
    Integer five = Integer.valueOf(5);
    fl.add( five );
    return five.equals(fl.mostFrequent());
  }
  
  /* Adds many items to an empty list (some repeated), then tests
   * the mostFrequent() method on this list. */
  public static boolean testFreqMany() {
    FrequencyList<String> fl = new FrequencyList<String>();
    fl.add( "hello" );
    fl.add( "goodbye" );
    fl.add( "hello" );
    fl.add( "goodbye" );
    fl.add( "aloha" );
    fl.add( "goodbye" );
    fl.add( "adios" );
    return "goodbye".equals(fl.mostFrequent());
  }
  
  /* Tests the mostFrequent(int k) method when the length
   * of the list is less than k. */
  public static boolean testMostFreqSmall() {
    FrequencyList<Double> fl = new FrequencyList<Double>();
    fl.add( Double.valueOf(6.6) );
    fl.add( Double.valueOf(6.6) );
    fl.add( Double.valueOf(7.7) );
    fl.add( Double.valueOf(4.4) );
    fl.add( Double.valueOf(7.7) );
    fl.add( Double.valueOf(6.6) );
    
    GenList<FrequencyPair<Double>> expected = 
      createList( new Double[]{ 4.4, 7.7, 6.6 }, new int[]{ 1, 2, 3 } );
    
    return listsEqual( expected, fl.mostFrequent(5) );
  }
  
  /* Tests the mostFrequent(int k) method when the length
   * of the list is more than k. */
  public static boolean testMostFreqBig() {
    FrequencyList<String> fl = new FrequencyList<String>();
    fl.add( "how" );
    fl.add( "much" );
    fl.add( "wood" );
    fl.add( "could" );
    fl.add( "a" );
    fl.add( "wood" );
    fl.add( "chuck" );
    fl.add( "chuck" );
    fl.add( "if" );
    fl.add( "a" );
    fl.add( "wood" );
    fl.add( "chuck" );
    fl.add( "could" );
    fl.add( "chuck" );
    fl.add( "wood" );
    
    fl.add( "chuck" ); // for frequency uniqueness
    
    GenList<FrequencyPair<String>> expected =
      createList( new String[]{ "wood", "chuck" }, new int[]{ 4, 5 } );
    
    return listsEqual( expected, fl.mostFrequent(2) );
  }
  
  /* Helper method for the mostFrequent(int k) tests.
   * pre: items.length == frequencies.length
   * return: A GenList of FrequencyPair<T>s with items.length
   *         elements, such that the i'th element has item
   *         items[i] and frequency frequencies[i].
   */
  private static <T> GenList<FrequencyPair<T>> createList( T[] items, int[] frequencies ) {
    GenList<FrequencyPair<T>> toRet = null;
    
    for( int i = items.length - 1; i >= 0; --i )
      toRet = new GenList<FrequencyPair<T>>( new FrequencyPair<T>(items[i],frequencies[i]), toRet );
    
    return toRet;
  }
  
  /* Helper method for the mostFrequent(int k) tests.
   * Tests whether the two given lists are equal.
   * pre: true
   * return: true iff lst1 and lst2 have the same number of
   *         elements, and the same elements in corresponding positions
   *         are .equal to each other.
   */
  private static <T> boolean listsEqual( GenList<FrequencyPair<T>> lst1, GenList<FrequencyPair<T>> lst2 ) {
    if( (null == lst1) && (null == lst2) )
      return true;
    else if( (null == lst1) || (null == lst2) )
      return false;
    else if( !lst1.first.equals(lst2.first) ) {
      return false;
    }
    else
      return listsEqual( lst1.rest, lst2.rest );
  }
  
  /* A main method to run the tests.
   * NOTE: Your main methods for assignments do not need to be this sophisticated.
   */
  public static void main( String[] args ) {
    boolean passAll = true;

    if( testEmptyLengthNone() )
      System.out.println("pass " + "testEmptyLengthNone");
    else {
      System.out.println("FAIL for test " + "testEmptyLengthNone");
      passAll = false;
    }

    if( testEmptyLengthMany() )
      System.out.println("pass " + "testEmptyLengthMany");
    else {
      System.out.println("FAIL for test " + "testEmptyLengthMany");
      passAll = false;
    }

    if( testFreqOne() )
      System.out.println("pass " + "testFreqOne");
    else {
      System.out.println("FAIL for test " + "testFreqOne");
      passAll = false;
    }

    if( testFreqMany() )
      System.out.println("pass " + "testFreqMany");
    else {
      System.out.println("FAIL for test " + "testFreqMany");
      passAll = false;
    }

    if( testMostFreqSmall() )
      System.out.println("pass " + "testMostFreqSmall");
    else {
      System.out.println("FAIL for test " + "testMostFreqSmall");
      passAll = false;
    }

    if( testMostFreqBig() )
      System.out.println("pass " + "testMostFreqBig");
    else {
      System.out.println("FAIL for test " + "testMostFreqBig");
      passAll = false;
    }

    if( true == passAll )
      System.out.println("All tests passed.");
  }

}