/* Sequence.java
 * CS 136 Spring 2007
 * Tutorial 12: Double Arrays and Polymorphism
 */

/* This class represents a non-decreasing arithmetic sequence, i.e. a sequence
 * of numbers (a,a+b,a+2b,a+3b,...) such that the i'th number is given by a+bi.
 */
public class Sequence {
  // The integers that define this sequence
  private int a,b;
  
  // The current value in the sequence
  private int accumulator;
  
  /* Creates a new sequence, with initial value start and
   * the difference between successive values increment.
   * pre: increment >= 0
   */
  public Sequence( int start, int increment ) {
    a = start;
    b = increment;
    accumulator = a;
  }
  
  /* Resets this sequence so that the next value returned
   * by next() will be the first value in the sequence.
   * pre: true
   * post: the next value returned by next() is the first
   *       value in the sequence.
   */
  public void reset() {
    accumulator = a;
  }
  
  /* Returns the next integer in the sequence.
   * pre: true
   * post: The value returned when next() is called again
   *       will be the following integer in the sequence.
   * return: The current sequence value.
   */
  public int next() {
    int toRet = accumulator;
    accumulator += b;
    return toRet;
  }
}