/* GradeBook.java (skeleton)
 * CS 136 Spring 2007
 * Tutorial 12: Double Arrays and Polymorphism
 */

/* This class stores a list of students and their marks on
 * some number of assignments (at most 100).
 */
public class GradeBook {
  // The students' names
  private String[] students;
  
  // The double-array of marks. The first index is the student,
  // and the second index is the assignment number.
  private int[][] marks;
  
  // The maximum scores for the assignments
  private int[] max;
  
  // The number of assignments entered so far
  private int nAssignments;
  
  /* Creates a new gradebook from the given list of student names.
   * pre: studentNames != null, each name in studentNames is not null
   */
  public GradeBook( String[] studentNames ) {
  }
  
  /* Gets the number of assignments entered so far.
   * pre: true
   * post: true
   * return: the number of assignments entered so far.
   */
  public int numAssignments() { 
    return nAssignments;
  }
  
  /* Gets the number of students in the gradebook
   * pre: true
   * post: true
   * return: the number of students in the gradebook
   */
  public int numStudents() {
    return students.length;
  }
  
  /* Adds a new assignment to the gradebook.
   * pre: scores != null, each score in scores is at least 0,
   *      scores.length = (number of students in gradebook)
   *      maxScore > 0, numAssignments() < 100
   * post: A new assignment is added with the given scores for
   *       the corresponding students.
   */
  public void addAssignment( int[] scores, int maxScore ) {
  }
  
  /* Gets a single mark in the gradebook.
   * pre: student is the name of a student in the gradebook,
   *      0 <= asst < numAssignments()
   * post: true
   * return: The mark that the named student got on the
   *         indicated assignment.
   */
  public int getMark( String student, int asst ) {
    return 0;
  }
  
  /* Changes a single mark in the gradebook.
   * pre: student is the name of a student in the gradebook,
   *      0 <= asst < numAssignments(), and newMark >= 0
   * post: The mark for the given student and the given assignment index
   *       is set to the value of newMark.
   */
  public void changeMark( String student, int asst, int newMark ) {
  }
  
  /* Gets the average mark for a given assignment.
   * pre: 0 <= asst < numAssignments()
   * post: true
   * return: The average mark for all the students on the specified assignment.
   */
  public double avgMark( int asst ) {
    return 0.0;
  }
  
  /* Gets the average percentage for the named student over
   * all assignments.
   * pre: name is the name of a student in the handbook
   * post: true
   * return: The named student's score on each assignment is
   *         scaled from 0-1 (according to the corresponding
   *         max score), and the average of these scaled values
   *         is returned.
   */
  public double studentAvg( String name ) {
    return 0.0;
  }
  
  /* Gets the student with the highest average according to studentAvg.
   * pre: true
   * post: true
   * return: The name of the student with the highest value
   *         from the method studentAvg.
   */
  public String topStudent() {
    return null;
  }
  
  /* Curves the specified assignment to the highest grade.
   * pre: 0 <= asst < numAssignments()
   * post: All students' scores on the specified assignment are
   *       multiplied by the same constant (possibly rounded down)
   *       so that at least one student has the maximum score (and
   *       none have more than the maximum).
   */
  public void curveAssignment( int asst ) {
  }
}