/* GeometricSeq.java
 * CS 136 Spring 2007
 * Tutorial 12: Double Arrays and Polymorphism
 */

/* This class represents a non-decreasing geometric sequence, i.e. a sequence
 * of numbers (a,ab,ab^2,ab^3,...) such that the i'th number is given by a*b^i.
 */
public class GeometricSeq implements SummableSeq {
  // The integers that define this sequence
  private int a,b;
  
  // The current value in the sequence
  private int accumulator;
  
  /* Creates a new sequence, with initial value start and
   * the difference between successive values increment.
   * pre: ratio >= 1
   */
  public GeometricSeq( int start, int ratio ) {
    a = start;
    b = ratio;
    accumulator = a;
  }
  
  /* Resets this sequence so that the next value returned
   * by next() will be the first value in the sequence.
   * pre: true
   * post: the next value returned by next() is the first
   *       value in the sequence.
   */
  public void reset() {
    accumulator = a;
  }
  
  /* Returns the next integer in the sequence.
   * pre: true
   * post: The value returned when next() is called again
   *       will be the following integer in the sequence.
   * return: The current sequence value.
   */
  public int next() {
    int toRet = accumulator;
    accumulator *= b;
    return toRet;
  }
  
  /* Sums the first k values of the given sequence.
   * pre: k >= 0
   * return: The sum of the first k values in this sequence.
   */
  public int sumFirst(int k) {
    return a*(pow(b,k)-1)/(b-1);
  }
  
  /* Raise the given integer to the given power.
   * This is equivalent to writing (int)Math.pow(m,n)
   * but I felt like writing it anyway.
   * return: m to the power n
   */
  public static int pow(int m, int n) {
    int toRet = 1, mpow = m, exp=n;
    while( exp > 0 ) {
      if( exp % 2 == 1 )
        toRet *= mpow;
      mpow *= mpow;
      exp /= 2;
    }
    return toRet;
  }
}