/* SequenceUtils.java
 * CS 136 Spring 2007
 * Tutorial 12: Double Arrays and Polymorphism
 */

/* This class provides some utility and computation functions
 * for non-decreasing sequences. */
public class SequenceUtils {
  
  /* Sums the first k values of the given sequence.
   * pre: s != null, k >= 0
   * return: The sum of the first k values in s.
   */
  public static int sumFirst( Sequence s, int k ) {
    if( s instanceof SummableSeq )
      return sumFirst( (SummableSeq)s, k );
    else {
      int accum = 0;
      s.reset();
      for( int i = 0; i < k; ++i )
        accum += s.next();
      return accum;
    }
  }
  
  /* Sums the first k values of the given sequence.
   * Calls the sumFirst method in SummableSeq
   * pre: s != null, k >= 0
   * return: The sum of the first k values in s.
   */
  public static int sumFirst( SummableSeq ss, int k ) {
    return ss.sumFirst(k);
  }
  
  /* Finds the sequence among those given whose values first
   * exceed the given number.
   * pre: a != null, each sequence in a not null.
   * return: The first exceeding sequence.
   */
  public static Sequence firstExceeding( Sequence[] a, int k ) {
    for( Sequence s : a ) // Note: shorthand syntax for "for" loop!
      s.reset();
    
    while( true ) {
      for( Sequence s : a ) {
        if( s.next() >= k ) return s;
      }
    }
  }
  
  /* Prints out the first k values of the given sequence, one per line.
   * pre: s != null
   */
  public static void printFirst( Sequence s, int k ) {
    s.reset();
    for( int i = 0; i < k; ++i )
      System.out.println(s.next());
  }
  
}