/* FibonacciSeq.java
 * CS 136 Spring 2007
 * Tutorial 12: Double Arrays and Polymorphism
 */

/* This class represents the Fibonacci sequence: 0,1,1,2,3,5,8,... */
public class FibonacciSeq implements Sequence {
  // The previous number in the sequence (or 1 to start with)
  int prev;
  
  // The current number in the sequence
  int current;
  
  /* Creates a new instance of this class.
   * No arguments because there is just one sequence of
   * Fibonacci numbers.
   */
  public FibonacciSeq() {
    prev = 1;
    current = 0;
  }
  
  /* Resets this sequence so that the next value returned
   * by next() will be the first value in the sequence.
   * pre: true
   * post: the next value returned by next() is the first
   *       value in the sequence.
   */
  public void reset() {
    prev = 1;
    current = 0;
  }
  
  /* Returns the next integer in the sequence.
   * pre: true
   * post: The value returned when next() is called again
   *       will be the following integer in the sequence.
   * return: The current sequence value.
   */
  public int next() {
    int toRet = current;
    current += prev;
    prev = toRet;
    return toRet;
  }
}