/* GradeBookTest.java
 * CS 136 Spring 2007
 * Tutorial 12: Double Arrays and Polymorphism
 */

/* Tests for the GradeBook class. */
public class GradeBookTest {
  
  /* Helper method which just creates and returns a sample
   * GradeBook for testing. */
  private static GradeBook makeTestGB() {
    String[] names = {"Leonard Bernstein","Richard Strauss","Alban Berg",
      "Thomas Beversdorf","James Barnes","Bernard Heiden"};
    GradeBook gb = new GradeBook(names);
    gb.addAssignment( new int[]{54,91,53,64,87,42}, 100 );
    gb.addAssignment( new int[]{4,5,3,4,6,2}, 6 );
    gb.addAssignment( new int[]{5,11,6,3,4,2}, 11 );
    return gb;
  }
  
  /* Tests the addAssignment and getMark methods. */
  public static boolean testAddAssignment() {
    String[] names = {"Nancy", "Pete", "Neal", "Bob"};
    GradeBook gb = new GradeBook( names );
    int[] marks1 = {42,345,23,14};
    int[] marks2 = {25,325,694,15};
    gb.addAssignment(marks1, 400);
    gb.addAssignment(marks2, 1000);
    return (gb.getMark("Nancy",0) == 42) &&
      (gb.getMark("Neal",1) == 694) &&
      (gb.getMark("Bob",0) == 14) &&
      (gb.getMark("Bob",1) == 15);
  }
  
  /* Tests the numAssignments and numStudents methods. */
  public static boolean testNumMethods() {
    String[] names = {"Nancy", "Pete", "Neal", "Bob"};
    GradeBook gb = new GradeBook( names );
    int[] marks = {1,2,3,4};
    if( (gb.numAssignments() != 0) || (gb.numStudents() != 4) )
      return false;
    gb.addAssignment(marks, 4);
    gb.addAssignment(marks, 10);
    return (gb.numAssignments() == 2) && (gb.numStudents() == 4);
  }
  
  /* Tests the changeMark method. */
  public static boolean testChangeMark() {
    GradeBook gb = makeTestGB();
    if( gb.getMark("Alban Berg",2) != 6 ) return false;
    gb.changeMark("Alban Berg",2,523);
    return gb.getMark("Alban Berg",2) == 523;
  }
  
  /* Tests the avgMark method. */
  public static boolean testAvgMark() {
    GradeBook gb = makeTestGB();
    return (gb.avgMark(1) == 4.0) &&
      (gb.avgMark(0) == (54.0+91.0+53.0+64.0+87.0+42.0)/6.0);
  }
  
  /* Tests the studentAvg method. */
  public static boolean testStudentAvg() {
    GradeBook gb = makeTestGB();
    return (gb.studentAvg("James Barnes") == (0.87 + 1.0 + 4.0/11.0)/3.0);
  }
  
  /* Tests the topStudent method. */
  public static boolean testTopStudent() {
    GradeBook gb = makeTestGB();
    return gb.topStudent().equals("Richard Strauss");
  }
  
  /* Tests the curveAssignment method when there's no change
   * (i.e. one student already has the max score). */
  public static boolean testCurveAssignmentNothing() {
    GradeBook gb = makeTestGB();
    double prev = gb.avgMark(2);
    gb.curveAssignment(2);
    return (gb.avgMark(2) == prev);
  }
  
  /* Tests the curveAssignment method when there's 
   * actually something to change. */
  public static boolean testCurveAssignmentSomething() {
    GradeBook gb = makeTestGB();
    double prev = gb.avgMark(0);
    double ratio = 100.0/91.0;
    gb.curveAssignment(0);
    return (gb.getMark("Richard Strauss",0) == 100) &&
      (Math.abs(gb.avgMark(0) - prev*ratio) < 1.0);
  }
  
  /* Run the tests and print the results. */
  public static void main(String[] args) {
    boolean passAll = true;

    if( testAddAssignment() )
      System.out.println("pass " + "testAddAssignment");
    else {
      System.out.println("FAIL for test " + "testAddAssignment");
      passAll = false;
    }

    if( testNumMethods() )
      System.out.println("pass " + "testNumMethods");
    else {
      System.out.println("FAIL for test " + "testNumMethods");
      passAll = false;
    }

    if( testChangeMark() )
      System.out.println("pass " + "testChangeMark");
    else {
      System.out.println("FAIL for test " + "testChangeMark");
      passAll = false;
    }

    if( testAvgMark() )
      System.out.println("pass " + "testAvgMark");
    else {
      System.out.println("FAIL for test " + "testAvgMark");
      passAll = false;
    }

    if( testStudentAvg() )
      System.out.println("pass " + "testStudentAvg");
    else {
      System.out.println("FAIL for test " + "testStudentAvg");
      passAll = false;
    }

    if( testTopStudent() )
      System.out.println("pass " + "testTopStudent");
    else {
      System.out.println("FAIL for test " + "testTopStudent");
      passAll = false;
    }

    if( testCurveAssignmentNothing() )
      System.out.println("pass " + "testCurveAssignmentNothing");
    else {
      System.out.println("FAIL for test " + "testCurveAssignmentNothing");
      passAll = false;
    }

    if( testCurveAssignmentSomething() )
      System.out.println("pass " + "testCurveAssignmentSomething");
    else {
      System.out.println("FAIL for test " + "testCurveAssignmentSomething");
      passAll = false;
    }

    if( true == passAll )
      System.out.println("All tests passed.");
  }
}

