/* Endpoint.java (skeleton code)
 * CS 136 Spring 2007
 * Tutorial 9 - Hello Java
 */

/* An object of this class represents one endpoint (possibly infinite) of an
 * interval on the real number line.
 */
public class Endpoint {
  
  /* The location of the endpoint. For infinite endpoints, only the sign matters. */
  private double location;
  
  /* If true, this endpoint is infinite. 
   * Note that double values can actually be +/- infinity in Java,
   * but we're going to use a boolean just to make things clear.
   */
  private boolean infinite;
  
  /* If true, this is a closed endpoint; otherwise it is open. */
  private boolean closed;
  
  /* Creates an endpoint at a given finite location.
   */
  public Endpoint( double loc, boolean isClosed ) {
    location = loc;
    closed = isClosed;
    infinite = false;
  }
  
  /* Creates an infinite endpoint
   * pre: sign must be one of '+' for positive infinity or '-' for negative infinity.
   */
  public Endpoint( char sign ) {
    infinite = true;
    closed = false;
    if( sign == '-' ) location = -1.0;
    else if( sign == '+' ) location = 1.0;
    else { // Similar to (error "...") in Scheme
      throw new RuntimeException( "sign must be '+' or '-'" );
    }
  }
  
  /* Tests whether the interval from this endpoint to the given one is empty or not.
   * other: The endpoint to test against. Must not be null.
   * pre: true
   * post: true
   * return: true if and only if the interval from this endpoint to the given one
   *         contains at least one number.
   */
  public boolean intervalNotEmpty( Endpoint other ) {
    return false;
  }
  
}