/* EndpointTest.java (skeleton version)
 * CS 136 Spring 2007
 * Tutorial 9 - Hello Java
 */

/* Tests for the Endpoint class. */
public class EndpointTest {
  
  /* Tests the intervalNotEmpty method
   * when both endpoints are finite. */
  public static boolean testFiniteNotEmpty() {
    Endpoint e1 = new Endpoint(4,true);
    Endpoint e2 = new Endpoint(-3,true);
    Endpoint e3 = new Endpoint(0.5,false);
    return e1.intervalNotEmpty(e1) &&
           e2.intervalNotEmpty(e1) &&
           !e1.intervalNotEmpty(e2) &&
           !e3.intervalNotEmpty(e3) &&
           e3.intervalNotEmpty(e1) &&
           !e3.intervalNotEmpty(e2);
  }
  
  /* Tests the intervalNotEmpty method
   * when one or both endpoints are infinite. */
  public static boolean testInfiniteNotEmpty() {
    Endpoint pinf = new Endpoint('+');
    Endpoint ninf = new Endpoint('-');
    Endpoint real = new Endpoint(5,true);
    
    return !ninf.intervalNotEmpty(ninf) &&
           ninf.intervalNotEmpty(pinf) &&
           !pinf.intervalNotEmpty(ninf) &&
           ninf.intervalNotEmpty(real) &&
           real.intervalNotEmpty(pinf) &&
           !real.intervalNotEmpty(ninf);
  }
  
  /* Run the tests */
  public static void main( String[] args ) {
    System.out.println( "testFiniteNotEmpty: " + testFiniteNotEmpty() );
    System.out.println( "testInfiniteNotEmpty: " + testInfiniteNotEmpty() );
  }

}