/* EndpointTest.java
 * CS 136 Spring 2007
 * Tutorial 9 - Hello Java
 */

/* Tests for the Endpoint class. */
public class EndpointTest {
  
  /* Tests the intervalNotEmpty method
   * when both endpoints are finite and closed. */
  public static boolean testFiniteClosedNotEmpty() {
    Endpoint e1 = new Endpoint(4,true);
    Endpoint e2 = new Endpoint(-3,true);
    return 
      e1.intervalNotEmpty(e1) &&
      e2.intervalNotEmpty(e1) &&
      !e1.intervalNotEmpty(e2);
  }
  
  /* Tests the intervalNotEmpty method
   * when both endpoints are finite and
   * at one endpoint is open. */
  public static boolean testFiniteOpenNotEmpty() {
    Endpoint e1 = new Endpoint(-1.5,true);
    Endpoint e2 = new Endpoint(-.5,false);
    return 
      !e2.intervalNotEmpty(e2) &&
      e1.intervalNotEmpty(e2) &&
      !e2.intervalNotEmpty(e1);
  }
  
  /* Tests the intervalNotEmpty method
   * when both endpoints are infinite. */
  public static boolean testInfiniteNotEmpty() {
    Endpoint pinf = new Endpoint('+');
    Endpoint ninf = new Endpoint('-');
    
    return !ninf.intervalNotEmpty(ninf) &&
           ninf.intervalNotEmpty(pinf) &&
           !pinf.intervalNotEmpty(ninf);
  }
  
  /* Tests the intervalNotEmpty method
   * when one endpoint is finite and the other is infinite. */
  public static boolean testIFNotEmpty() {
    Endpoint ninf = new Endpoint('-');
    Endpoint real = new Endpoint(5.0,true);
    return 
      ninf.intervalNotEmpty(real) &&
      !real.intervalNotEmpty(ninf);
  }
  
  /* Tests the scale method on a finite endpoint with
   * a positive magnitude. */
  public static boolean testFinitePosScale() {
    Endpoint zero = new Endpoint(0,true);
    Endpoint e1 = new Endpoint(3,true);
    Endpoint e2 = new Endpoint(5,true);
    
    zero.scale(50);
    e1.scale(2); // Now e1 is 6
    return
      zero.intervalNotEmpty(e1) &&
      e2.intervalNotEmpty(e1);
  }
  
  /* Tests the scale method on a finite endpoint with
   * a negative magnitude. */
  public static boolean testFiniteNegScale() {
    Endpoint e1 = new Endpoint(-3,true);
    Endpoint e2 = new Endpoint(5,true);
    
    e1.scale(-2); // Now e1 is 6
    return e2.intervalNotEmpty(e1);
  }
  
  /* Tests the scale method on an infinite endpoint. */
  public static boolean testInfiniteScale() {
    Endpoint inf = new Endpoint('+');
    Endpoint one = new Endpoint(1,false);
    
    inf.scale(.00001);
    if( inf.intervalNotEmpty(one) ) return false;
    inf.scale(-1000);
    return inf.intervalNotEmpty(one);
  }
  
  /* Run the tests */
  public static void main( String[] args ) {
    System.out.println( "testFiniteClosedNotEmpty: " + testFiniteClosedNotEmpty() );
    System.out.println( "testFiniteOpenNotEmpty: " + testFiniteOpenNotEmpty() );
    System.out.println( "testInfiniteNotEmpty: " + testInfiniteNotEmpty() );
    System.out.println( "testIFNotEmpty: " + testIFNotEmpty() );
    System.out.println( "testFinitePosScale: " + testFinitePosScale() );
    System.out.println( "testFiniteNegScale: " + testFiniteNegScale() );
    System.out.println( "testInfiniteScale: " + testInfiniteScale() );
  }

}