/* Interval.java
 * CS 136 Spring 2007
 * Tutorial 9 - Hello Java
 */

/* An object of this class represents a single interval on the real number line. */
public class Interval {
  
  /* The left endpoint of the interval. */
  private Endpoint left;
  
  /* The right endpoint of the interval. */
  private Endpoint right;
  
  /* Creates a new interval with the given endpoints.
   */
  public Interval( Endpoint leftEnd, Endpoint rightEnd ) {
    left = leftEnd;
    right = rightEnd;
  }
  
  /* Tests whether the given number is contained in this interval.
   * return: true iff the given point is in this interval.
   */
  public boolean contains( double point ) {
    Endpoint testPoint = new Endpoint( point, true );
    return left.intervalNotEmpty(testPoint) &&
           testPoint.intervalNotEmpty(right);
  }
  
  /* Scale this interval by the given factor.
   * pre: true
   * post: All finite endpoints are multiplied by the given magnitude.
   */
  public void scale( double magnitude ) {
    left.scale(magnitude);
    right.scale(magnitude);
    
    // If magnitude is negative, we have to swap left/right
    if( magnitude < 0 ) {
      Endpoint temp = left;
      left = right;
      right = temp;
    }
  }

}