/* IntervalTest.java
 * CS 136 Spring 2007
 * Tutorial 9 - Hello Java
 */

/* Tests for the Interval and Endpoint classes. */
public class IntervalTest {
  
  /* Tests the contains method when both endpoints are finite. */
  public static boolean testFiniteContains() {
    Interval i1 = new Interval( new Endpoint(-2,false), new Endpoint(3.3,true) );
    return i1.contains(0) &&
           i1.contains(-1) &&
           i1.contains(3.3) &&
           !i1.contains(-2) &&
           i1.contains(-1.99) &&
           !i1.contains(4);
  }
  
  /* Tests the contains method when one endpoint is infinite. */
  public static boolean testHalfInfiniteContains() {
    Interval i = new Interval(new Endpoint('-'), new Endpoint(-2.4,true));
    return i.contains(-100) &&
           i.contains(-3) &&
           !i.contains(-1) &&
           !i.contains(100);
  }
  
  /* Tests the contains method when both endpoints are infinite. */
  public static boolean testInfiniteContains() {
    Interval i = new Interval(new Endpoint('-'),new Endpoint('+'));
    return i.contains(-423.234) && i.contains(0) && i.contains(.0900424);
  }
  
  /* Tests the scale method when the magnitude is positive */
  public static boolean testScalePositive() {
    Interval i = new Interval(new Endpoint(-30,false),new Endpoint('+'));
    i.scale(.1);
    
    return i.contains(0) &&
           i.contains(-2.9) &&
           !i.contains(-3) &&
           !i.contains(-100) &&
           i.contains(42389.24);
  }
  
  /* Tests the scale method when the magnitude is negative */
  public static boolean testScaleNegative() {
    Interval i = new Interval( new Endpoint('-'), new Endpoint(.5,true) );
    i.scale(-100);
    
    return i.contains(-50) &&
           i.contains(1234567) &&
           i.contains(0) &&
           !i.contains(-100);
  }
  
  /* Run the tests */
  public static void main( String[] args ) {
    System.out.println( "testFiniteContains: " + testFiniteContains() );
    System.out.println( "testHalfInfiniteContains: " + testHalfInfiniteContains() );
    System.out.println( "testInfiniteContains: " + testInfiniteContains() );
    System.out.println( "testScalePositive: " + testScalePositive() );
    System.out.println( "testScaleNegative: " + testScaleNegative() );
  }

}