/* SI 413 Fall 2011
 * inst.hpp
 * Instruction execution for SVM 2.0
 */

#include <vector>
#include <map>
#include "inst.hpp"

using namespace std;

void Inst::exec(Program& p) const {
  Value v, v1, v2;
  int x;
  size_t ln;
  bool b;

  switch(code) {
    case LITERAL: p.vstack.push_back(arg); break;

    case PRINT: cout << p.stackPop() << endl; break;
    case POP: p.stackPop(); break;

    case READ: v.readFrom(cin); p.vstack.push_back(v); break;

    case ADD: 
      x = p.stackPop().num();
      v.setNum(p.stackPop().num() + x);
      p.vstack.push_back(v); break;
    case SUB:
      x = p.stackPop().num();
      v.setNum(p.stackPop().num() - x);
      p.vstack.push_back(v); break;
    case MUL:
      x = p.stackPop().num();
      v.setNum(p.stackPop().num() * x);
      p.vstack.push_back(v); break;
    case DIV:
      x = p.stackPop().num();
      v.setNum(p.stackPop().num() / x);
      p.vstack.push_back(v); break;
    
    case EQ:
      v2 = p.stackPop();
      v1 = p.stackPop();
      v.setBool(v1 == v2);
      p.vstack.push_back(v); break;
    case LT:
      x = p.stackPop().num();
      v.setBool(p.stackPop().num() < x);
      p.vstack.push_back(v); break;
    case LE:
      x = p.stackPop().num();
      v.setBool(p.stackPop().num() <= x);
      p.vstack.push_back(v); break;

    case AND:
      b = p.stackPop().tf();
      v.setBool(p.stackPop().tf() && b);
      p.vstack.push_back(v); break;
    case OR:
      b = p.stackPop().tf();
      v.setBool(p.stackPop().tf() || b);
      p.vstack.push_back(v); break;
    case NOT:
      v.setBool(! p.stackPop().tf());
      p.vstack.push_back(v); break;

    case DUP: 
      v = p.stackPop();
      p.vstack.push_back(v);
      p.vstack.push_back(v); 
      break;

    case LOAD:
      v = p.memLookup(p.stackPop().num());
      p.vstack.push_back(v); break;

    case STORE:
      x = p.stackPop().num();
      p.memory[x] = p.stackPop();
      break;

    case BRANCH:
      ln = p.stackPop().line();
      if (p.stackPop().tf()) p.ip = p.findLabel(ln);
      break;
    case GOTO: 
      p.ip = p.findLabel(p.stackPop().line()); 
      break;
    
    case PRINTST: p.printVstack(); break;
    case CLEARST: p.vstack.clear(); break;

    case EXIT: exit(0);
    case NOP: break;

    case LABEL:
    case GO:
    case HELP:
      cerr << "LABEL, GO, and HELP shouldn't be in the stored program!" << endl;
  }
}


void Program::exec() {
  while (ip < size()) {
    //cout << "Executing instruction " << ip << endl;
    const Inst& next = at(ip);
    ++ip;
    next.exec(*this);
  }
  //cout << "Done executing; ip is " << ip << endl;
}

void Program::printVstack() const {
  cout << "||";
  for (size_t i=0; i<vstack.size(); ++i)
    cout << ' ' << vstack[i];
  cout << endl;
}

size_t Program::findLabel(int l) const {
  map<int,size_t>::const_iterator iter = labels.find(l);
  if (iter == labels.end()) {
    cerr << "No label number " << l << " has been defined in this program!"
      << endl;
    exit(6);
  }
  return iter->second;
}

Value Program::memLookup(int n) const {
  map<int,Value>::const_iterator iter = memory.find(n);
  if (iter == memory.end()) {
    cerr << "Memory address " << n << " has not yet been assigned a value!"
      << endl;
    exit(7);
  }
  return iter->second;
}

Value Program::stackPop() {
  if (vstack.empty()) {
    cerr << "Not enough arguments on the vstack; aborting" << endl;
    exit(8);
  }
  Value toret = vstack.back();
  vstack.pop_back();
  return toret;
}
