/* SI 413 Fall 2011
 * inst.hpp
 * Instruction class for SVM 2.0
 */

#ifndef INST_HPP
#define INST_HPP

#include <vector>
#include <map>
#include "value.hpp"

enum Icode {
  LITERAL, POP,
  PRINT, READ,
  ADD, SUB, MUL, DIV,
  EQ, LT, LE,
  AND, OR, NOT,
  DUP, LOAD, STORE,
  LABEL, GOTO, BRANCH,
  PRINTST, CLEARST,
  EXIT, GO, HELP, NOP
};

class Program;

class Inst {
  public:
    Icode code;
    Value arg;

    Inst() :code(NOP) { }

    void exec(Program& p) const;
};

class Program :public std::vector<Inst> {
  public:
    size_t ip; // Instruction pointer; indicates what to do next.
    std::map<int, size_t> labels;
    std::map<int, Value> memory;
    std::vector<Value> vstack;

    Program() :ip(0) { }

    void exec();

    void printVstack() const;

    size_t findLabel(int l) const;
    Value memLookup(int n) const;
    Value stackPop();
};

#endif // INST_HPP
