/* SI 413 Fall 2011
 * Implementations of methods related to Values and type checking.
 */

#include <string>
#include "value.hpp"
using namespace std;

ostream& operator<< (ostream& out, VType vt) {
  switch (vt) {
    case NUM_T:  return out << "NUM";
    case BOOL_T: return out << "BOOL";
    case LINE_T:  return out << "LINE";
    case NONE_T: return out << "NONE";
  }
}

ostream& operator<< (ostream& out, const Value& v) {
  v.writeTo(out);
  return out;
}

istream& operator>> (istream& in, Value& v) {
  v.readFrom(in);
  return in;
}

int Value::num() const {
  if (type == NUM_T) return val.num;
  else {
    cerr << "Type mismatch: expected NUM, got " << type << endl;
    exit(5);
  }
}

bool Value::tf() const {
  if (type == BOOL_T) return val.tf;
  else {
    cerr << "Type mismatch: expected BOOL, got " << type << endl;
    exit(5);
  }
}

size_t Value::line() const {
  if (type == LINE_T) return val.line;
  else {
    cerr << "Type mismatch: expected LINE, got " << type << endl;
    exit(5);
  }
}

void Value::writeTo(ostream& out) const {
  switch(type) {
    case NUM_T: out << val.num; break;
    case BOOL_T: out << (val.tf ? "true" : "false"); break;
    case LINE_T: out << "LINE:" << val.line; break;
    case NONE_T: out << "UNSET"; break;
  }
}

void Value::readFrom(istream& in) {
  string tok;
  in >> tok;
  if (tok[0] == 'l' || tok[0] == 'L') {
    type = LINE_T;
    val.line = strtoul(tok.c_str()+1, NULL, 10);
  }
  else if (tok[0] == '+' || tok[0] == '-' || isdigit(tok[0])) {
    type = NUM_T;
    val.num = atoi(tok.c_str());
  }
  else if (tok == "true") {
    type = BOOL_T;
    val.tf = true;
  }
  else if (tok == "false") {
    type = BOOL_T;
    val.tf = false;
  }
  else {
    cerr << "Couldn't convert " << tok << " to a value." << endl;
    type = NONE_T;
  }
}

bool Value::operator==(const Value& other) const {
  if (type != other.type) return false;
  switch(type) {
    case NUM_T: return val.num == other.val.num;
    case BOOL_T: return val.tf == other.val.tf;
    case LINE_T: return val.line == other.val.line;
    case NONE_T: return true;
  }
}
