/* SI 413 Fall 2011
 * value.hpp
 * C++ header file for the Value class.
 */

#ifndef VALUE_HPP
#define VALUE_HPP

#include <iostream>
#include <cstdlib>

// This gives the type of what's stored in the Value object.
// NONE_T means nothing has been set yet.
enum VType {
  NUM_T=0, BOOL_T, LINE_T, NONE_T
};

std::ostream& operator<< (std::ostream& out, VType vt);

class Value {
  private:
    // The value is either an int, a bool, or a line number.
    union {
      int num;
      bool tf;
      size_t line;
    } val;

    VType type;

  public:
    VType getType() { return type; }

    void setNum(int n) { type=NUM_T; val.num = n; }
    void setBool(bool b) { type=BOOL_T; val.tf = b; }
    void setLine(size_t l) { type=LINE_T; val.line = l; }

    int num() const;
    bool tf() const;
    size_t line() const;

    void writeTo(std::ostream& out) const;
    void readFrom(std::istream& in);

    bool operator==(const Value& other) const;
};

std::ostream& operator<< (std::ostream& out, const Value& v);
std::istream& operator>> (std::istream& in, Value& v);


#endif // VALUE_HPP
