/* SI 335 Sprint 2012
 * Project 2
 * This program checks whether a given file is properly formatted
 * for input.
 * The file in question should be piped/redirected to standard in.
 */

#include <cstdlib>
#include <cctype>
#include <iostream>
#include <string>
#include <bitset>

using namespace std;

void err (const char* msg) {
  cout << msg << endl;
  exit(1);
}

int main() {
  int k, n;
  string name;
  int num;

  if (! (cin >> k)) err ("Expected k, got error");
  if (k <= 0) err("k must be positive");

  for (int i=0; i<k; ++i) {
    if (!(cin >> name)) err("Expected service name, got error");
    if (isdigit(name[0]))
      err("Expected service name, got number");
  }

  if (!(cin >> n)) err ("Expected n, got error");
  if (n <= 0) err("n must be positive");

  bool** checks = new bool*[k];
  for (int i=0; i<k; ++i) {
    checks[i] = new bool[n];
    for (int j=0; j<n; ++j)
      checks[i][j] = false;
  }

  for (int i=0; i<n; ++i) {
    if (!(cin >> name)) err("Expected name, got error");
    if (isdigit(name[0]))
      err("Expected name, got number");
    for (int j=0; j<k; ++j) {
      if (! (cin >> num)) err("Expected rank, got error");
      if (num <= 0) err("Ranking number must be positive");
      if (num > n) err("Ranking number must be at most n");
      if (checks[j][num-1]) err("Duplicate ranking");
      checks[j][num-1] = true;
    }
  }

  if (cin >> name) err("Extra stuff at the end");

  for (int i=0; i<k; ++i) {
    int j=0;
    for (; j < n && checks[i][j]; ++j);
    if (j < n) err("Missing a ranking");
  }

  cout << "PASS" << endl;
  return 0;
}
