/* SI 335 Spring 2012
 * Project 2
 * This program reads names from the random-names.txt file
 * and generates test cases for the selection program at random.
 * It requires two command-line arguments, k and n.
 */

#include <cstdlib>
#include <ctime>
#include <fstream>
#include <iostream>
#include <string>
#include <algorithm>

using namespace std;

int main (int argc, char** argv) {
  if (argc != 3) {
    cerr << "Usage: " << argv[0] << " k n" << endl;
    return 1;
  }

  srand (time(NULL));

  int k = atoi(argv[1]);
  int n = atoi(argv[2]);

  ifstream namesin ("random-names.txt");
  string name;

  cout << k << endl;
  for (int i=0; i<k; ++i) {
    namesin >> name;
    cout << name << endl;
  }
  cout << endl;

  int** ranks = new int*[k];
  for (int i=0; i<k; ++i) {
    ranks[i] = new int[n];
    for (int j=0; j<n; ++j)
      ranks[i][j] = j+1;
    random_shuffle (ranks[i], ranks[i]+n);
  }

  cout << n << endl;
  for (int i=0; i<n; ++i) {
    namesin >> name;
    cout << name;
    for (int j=0; j<k; ++j) {
      cout << ' ' << ranks[j][i];
    }
    cout << endl;
  }

  // Clean-up
  for (int i=0; i<k; ++i) delete [] ranks[i];
  delete [] ranks;
  namesin.close();

  return 0;
}
