/* SI 335 Spring 2012
 * Project 6
 * This is a (very simple) program that generates random
 * test cases (search queries) for a given graph.
 * Besides the file that holds the graph, the only input
 * is the number of queries to generate. These can then be
 * fed into the "drive" program via standard in.
 */
#include <cstdlib>
#include <ctime>
#include <iostream>
#include <fstream>
#include <vector>
#include <algorithm>

using namespace std;

// Returns a random integer between 0 and n-1.
int randomInt(int n);

// Prints an error message and exits ungracefully
void error (const char* msg);

int main (int argc, char** argv) {
  srand(time(NULL));

  // Check command-line arguments
  if (argc != 3) {
    cerr << "Usage: " << argv[0] << " <k> <graph_file>" << endl;
    error ("Wrong number of arguments");
  }

  int k = atoi(argv[1]);
  if (k <= 0) error ("k must be positive");

  ifstream graph (argv[2]);
  if (!graph) error("Bad graph filename");

  int n, m;
  graph >> n >> m;

  // Read in city names
  vector<string> cities(n);
  for (int i=0; i<n; ++i)
    graph >> cities[i];

  graph.close();

  for (int i=0; i<k; ++i) {
    int u,v;
    do {
      u = randomInt(n);
      v = randomInt(n);
    } while (u == v);
    cout << cities[u] << ' ' << cities[v] << ' ' << randomInt(501) << endl;
  }

  return 0;
}

// Returns a random integer between 0 and n-1.
int randomInt(int n) {
  int r, max = RAND_MAX - ((RAND_MAX-n+1) % n);
  do { r = rand(); }
  while (r > max);
  return (r % n);
}

// Prints an error message and exits ungracefully
void error (const char* msg) {
  cerr << "ERROR:" << endl << msg << endl;
  exit(1);
}
