/* misc.h
 * Daniel S. Roche, January 2011
 * See COPYING.txt for permissions.
 *
 * Miscellaneous utilities for the interpolation code.
 * Header file
 */

#ifndef MISC_H
#define MISC_H

#include <NTL/tools.h>

NTL_OPEN_NNS

/* Seed NTL's random generator from an unsigned long long */
void ullseed (unsigned long long seed);

/* Initialize NTL's random seed from /dev/urandom and
 * (optionally) print its value to stdout.
 */
void randseed (bool printit = true); 

/* Computes a lower bound on lambda so that at least half the primes
 * between lambda and 2*lambda are good.
 * See Lemma 3.1 from Giesbrecht & Roche (2011).
 */
long goodp_bound (const ZZ& D, long T);

/* Computes a "best guess" bound on a small number to start searching
 *  for good primes.
 */
long guessp_bound (const ZZ& D, long T);

NTL_CLOSE_NNS

#endif // MISC_H
