/* test_blackbox.cc
 * Daniel S. Roche, January 2011
 * See COPYING.txt for permissions.
 *
 * Run some small tests of the blackbox.h code
 */

#include <iostream>
#include <fstream>
#include <vector>
#include <NTL/lzz_pX.h>
#include "misc.h"
#include "sparsepoly.h"
#include "blackbox.h"

NTL_CLIENT

int main (void) {
  cout << "********************************************************************************" << endl
       << "                             BLACKBOX TEST" << endl
       << "********************************************************************************" << endl;
  randseed();

  zz_p::init(29);
  long deg = 100;
  zz_pX f = random_zz_pX (deg);
  SparsePoly<zz_pX,zz_p> sf;
  conv(sf,f);
  FakeUniModBB<zz_pX,zz_p> bb (sf);
  zz_pX bbout, actualout;

  // Test an eval in the base field
  zz_pX x;
  SetCoeff(x,1);
  zz_p a;
  random(a);
  zz_pX apoly;
  SetCoeff(apoly,0,a);
  bb.eval (bbout, apoly, x);
  zz_p actual = eval(f,a);
  cout << bbout << endl;
  cout << actual << endl;
  if (bbout != actual) {
    cout << "FAIL" << endl;
    return 1;
  }

  // Now do a general test
  zz_pX g, h;
  random(g,20);
  random(h,NTL::deg(g));
  bb.eval (bbout, h, g);
  CompMod (actualout, f, h, zz_pXModulus(g));
  cout << bbout << endl;
  cout << actualout << endl;

  if (bbout != actualout) {
    cout << "FAIL" << endl;
    return 2;
  }

  cout << "SUCCESS" << endl;
  return 0;
}
