/* test_newinterp.cc
 * Daniel S. Roche, January 2011
 * See COPYING.txt for permissions.
 *
 * Run some small tests on our interpolation algorithms.
 */

#include <iostream>
#include <NTL/ZZ.h>
#include <NTL/lzz_p.h>
#include <NTL/ZZ_pX.h>
#include <NTL/ZZ_pEX.h>
#include "misc.h"
#include "newinterp.h"

NTL_CLIENT

typedef long BBase;
typedef zz_p Base;
typedef zz_pX Poly;

int main (int argc, char** argv) {
  cout << "********************************************************************************" << endl
       << "                             NEW METHOD TEST" << endl
       << "********************************************************************************" << endl;
  ZZ D;
  long T;
  unsigned long which;

  if (argc >= 2) which = strtoul(argv[1],NULL,2);
  else which = 7;

  if (which <= 0 || which > 7 || argc == 3 || argc > 4 ) {
    cout << "Usage: " << argv[0] << " [which-tests [degree-bound sparsity-bound]]" << endl
         << "\twhich-tests indicates which algorithms to test among:" << endl
         << "\t\t0: New method A" << endl
         << "\t\t1: New method B" << endl
         << "\tby writing 1 for that bit. So e.g. 10 means test New B only."
         << endl;
    return 1;
  }

  if (argc == 4) {
    conv(D,argv[2]);
    T = strtol(argv[3],NULL,10);
  }
  else {
    conv(D,"1000000");
    T = 5;
    cout << "D = " << D << " ; T = " << T << endl;
  }

  randseed();

  zz_p::init (3);
  ZZ_p::init (to_ZZ(3));

  BBase prime;
  conv(prime,5);
  //random(prime,3);
  Base::init(prime);
  Poly g;
  random(g,10);
  cout << "g: " << g << endl;
  cout << "diverse? " << (is_diverse<Poly,Base>(g) ? "yes" : "no") << endl;

  conv(prime,101);
  //random(prime,100);
  Base::init(prime);
  random(g,5);
  cout << "g: " << g << endl;
  cout << "diverse? " << (is_diverse<Poly,Base>(g) ? "yes" : "no") << endl;

  conv(prime,65521);
  //conv(prime,"1606938044258990275541962092341162602522202993782792835301611");
  //random(prime,1000);
  Base::init(prime);
  SparsePoly<Poly,Base> f;
  random(f,D,T);
  cout << "orig\t" << f << endl << endl;
  FakeUniModBB<Poly,Base> bb(f);

  if (which & 1) {
    cout << "========================== New method A  =======================================" << endl;
    SparsePoly<Poly,Base> out;
    new_interpA (out, bb, D, T);
    cout << out << endl;
    if (f != out) {
      cout << "FAIL" << endl;
      return 2;
    }
  }

  if (which & 2) {
    cout << "========================== New method B  =======================================" << endl;
    SparsePoly<Poly,Base> out;
    if (new_interpB (out, bb, D, T)) {
      cout << out << endl;
      if (f != out) {
        cout << "FAIL" << endl;
        return 2;
      }
    }
    else {
      cout << "KNOWN FAIL" << endl;
      return 2;
    }
  }

  cout << "SUCCESS" << endl;
  return 0;
}

