/* test_sparsepoly.cc
 * Daniel S. Roche, January 2011
 * See COPYING.txt for permissions.
 * 
 * Some small tests of the SparsePoly class
 */

#include <iostream>
#include <fstream>
#include <NTL/lzz_pX.h>
#include "misc.h"
#include "sparsepoly.h"

NTL_CLIENT

int main (void) {
  cout << "********************************************************************************" << endl
       << "                             SPARSEPOLY TEST" << endl
       << "********************************************************************************" << endl;
  randseed();

  zz_p::init(3);
  zz_pX a,b;
  SparsePoly<zz_pX,zz_p> c,d;
  random(a,20);
  cout << a << endl;
  conv(c,a);
  conv(b,c);
  cout << b << endl;
  cout << "tms(a): " << sparsity(a)
       << ", tms(c): " << c.rep.size()
       << endl;
  cout << (a == b ? "equal" : "unequal") << endl;
  cout << endl;
  if ((a != b) || (((unsigned long)sparsity(a)) != c.rep.size())) {
    cout << "FAIL" << endl;
    return 1;
  }

  random(c,to_ZZ(2000),10);
  cout << c << endl;
  conv(a,c);
  conv(d,a);
  cout << d << endl;
  cout << (c == d ? "equal" : "unequal") << endl;
  cout << "tms(a): " << sparsity(a)
       << ", tms(c): " << c.rep.size()
       << endl;
  if ((c != d) || (((unsigned long)sparsity(a)) != c.rep.size())) {
    cout << "FAIL" << endl;
    return 2;
  }
  cout << "SUCCESS" << endl;
  return 0;
}
