import pandas as pd

df = pd.read_csv('badcities.csv')

# select only lines with non-blank state
df = df[~df['state'].isna()]
# change missing populations to 10K
df['population'].fillna(10000, inplace=True)
# sort by population
df.sort_values(by=['population'], inplace=True)

df.to_csv('goodcities.csv', index=False)
